<?php
$options = array(
	'colormag_off_canvas_heading'        => array(
		'type'         => 'customind-accordion',
		'title'        => esc_html__( 'Off Canvas', 'colormag' ),
		'section'      => 'colormag_header_builder_off_canvas',
		'sub_controls' => apply_filters(
			'colormag_off_canvas_sub_controls',
			array(
				'colormag_off_canvas_width'      => array(
					'default'     => array(
						'size' => 320,
						'unit' => 'px',
					),
					'type'        => 'customind-slider',
					'title'       => esc_html__( 'Width', 'colormag' ),
					'section'     => 'colormag_header_builder_off_canvas',
					'transport'   => 'postMessage',
					'units'       => array( 'px' ),
					'defaultUnit' => 'px',
					'input_attrs' => array(
						'min'  => 100,
						'max'  => 800,
						'step' => 1,
					),
				),
				'colormag_off_canvas_background' => array(
					'default'   => array(
						'background-color'      => '',
						'background-image'      => '',
						'background-repeat'     => 'repeat',
						'background-position'   => 'center center',
						'background-size'       => 'contain',
						'background-attachment' => 'scroll',
					),
					'type'      => 'customind-background',
					'title'     => esc_html__( 'Background', 'colormag' ),
					'section'   => 'colormag_header_builder_off_canvas',
					'transport' => 'postMessage',
				),

				'colormag_off_canvas_padding'    => array(
					'default'     => array(
						'top'    => '',
						'right'  => '',
						'bottom' => '',
						'left'   => '',
						'unit'   => 'px',
					),
					'type'        => 'customind-dimensions',
					'title'       => esc_html__( 'Padding', 'colormag' ),
					'section'     => 'colormag_header_builder_off_canvas',
					'units'       => array( 'px', 'em' ),
					'defaultUnit' => 'px',
					'transport'   => 'postMessage',
				),
			)
		),
		'collapsible'  => apply_filters( 'colormag_off_canvas_background_accordion_collapsible', false ),
	),
	'colormag_off_canvas_button_heading' => array(
		'type'         => 'customind-accordion',
		'title'        => esc_html__( 'Off Canvas Button', 'colormag' ),
		'section'      => 'colormag_header_builder_off_canvas',
		'sub_controls' => apply_filters(
			'colormag_off_canvas_button_sub_controls',
			array(
				'colormag_off_canvas_text'              => array(
					'title'     => esc_html__( 'Text', 'colormag' ),
					'default'   => '',
					'type'      => 'customind-text',
					'section'   => 'colormag_header_builder_off_canvas',
					'transport' => 'refresh',
				),
				'colormag_off_canvas_text_position'     => array(
					'default' => 'right',
					'type'    => 'customind-select',
					'title'   => esc_html__( 'Position', 'colormag' ),
					'section' => 'colormag_header_builder_off_canvas',
					'choices' => array(
						'left'  => esc_html__( 'Left', 'colormag' ),
						'right' => esc_html__( 'Right', 'colormag' ),
					),
				),
				'colormag_off_canvas_text_color'        => array(
					'default'   => '',
					'type'      => 'customind-color',
					'title'     => esc_html__( 'Color', 'colormag' ),
					'transport' => 'postMessage',
					'section'   => 'colormag_header_builder_off_canvas',
				),
				'colormag_off_canvas_button_background' => array(
					'default'   => array(
						'background-color'      => '',
						'background-image'      => '',
						'background-repeat'     => 'repeat',
						'background-position'   => 'center center',
						'background-size'       => 'contain',
						'background-attachment' => 'scroll',
					),
					'type'      => 'customind-background',
					'title'     => esc_html__( 'Background', 'colormag' ),
					'section'   => 'colormag_header_builder_off_canvas',
					'transport' => 'postMessage',
				),
				'colormag_off_canvas_button_padding'    => array(
					'default'     => array(
						'top'    => '',
						'right'  => '',
						'bottom' => '',
						'left'   => '',
						'unit'   => 'px',
					),
					'type'        => 'customind-dimensions',
					'title'       => esc_html__( 'Padding', 'colormag' ),
					'section'     => 'colormag_header_builder_off_canvas',
					'units'       => array( 'px', 'em' ),
					'defaultUnit' => 'px',
					'transport'   => 'postMessage',
				),
				'colormag_off_canvas_border_width'      => array(
					'default'     => array(
						'size' => 0,
						'unit' => 'px',
					),
					'type'        => 'customind-slider',
					'title'       => esc_html__( 'Border Width', 'colormag' ),
					'section'     => 'colormag_header_builder_off_canvas',
					'transport'   => 'postMessage',
					'units'       => array( 'px' ),
					'defaultUnit' => 'px',
					'input_attrs' => array(
						'min'  => 0,
						'max'  => 20,
						'step' => 1,
					),
				),
				'colormag_off_canvas_border_color'      => array(
					'default'   => '',
					'type'      => 'customind-color',
					'title'     => esc_html__( 'Color', 'colormag' ),
					'transport' => 'postMessage',
					'section'   => 'colormag_header_builder_off_canvas',
				),
				'colormag_off_canvas_border_radius'     => array(
					'default'     => array(
						'size' => '',
						'unit' => 'px',
					),
					'type'        => 'customind-slider',
					'title'       => esc_html__( 'Border Radius', 'colormag' ),
					'section'     => 'colormag_header_builder_off_canvas',
					'transport'   => 'postMessage',
					'units'       => array( 'px' ),
					'defaultUnit' => 'px',
					'input_attrs' => array(
						'min'  => 100,
						'max'  => 800,
						'step' => 1,
					),
				),
			)
		),
		'collapsible'  => apply_filters( 'colormag_off_canvas_button_background_accordion_collapsible', false ),
	),
);

colormag_customind()->add_controls( $options );
